# -*- coding: utf-8 -*-

import matplotlib.pyplot as plt
import numpy as np
from numpy.random import normal as randn
from numpy.linalg import norm, svd, qr, inv, eigh
from numpy import sqrt, trace
import scipy as sp


def Generate_H(alpha, d=int(1e4), reg=1):
    
    
    hs = np.array( [k**(-alpha) for k in range(1,d+1)] )
    
    d_eff = np.sum( hs/(hs+reg) )
    
    return hs, d_eff
    

def Find_Sketch_Dim(Hdiag, func_sketch, m0, d=int(1e4), reg=1):
    
    m = m0
    
    while (True):
    
        # print(m)    
    
        S = func_sketch(m,d)
        
        A = np.dot(S, np.diag(sqrt(Hdiag)) )
        
        _, s, _ = svd(A)
        
        z0 = -5*reg/12
        
        def sz(z):
            assert(m<=d)
            return np.sum(1/(s**2 - z0))/m
        
        if (sz(z0)>1/reg):
            return m
        else:
            m = 2*m
        

def Gauss_Sketch(m,d):
    return randn(0,1,size=(m,d))/sqrt(m)

def R_Sketch(m,d):
    return (2*np.random.binomial(1, 1/2,size=(m,d))-1)/sqrt(m)

def SR_Sketch(m,d):
    p=1/10
    return (2*np.random.binomial(1, 1/2,size=(m,d))-1)/sqrt(m) * np.random.binomial(1, p,size=(m,d))/sqrt(p)


def Experiment(alpha, sketch, T=20, reg=1):
    
    Ms = [10]
    
    for m0 in Ms:
    
        success_num=0
        sketch_dim_avg=0
        
        sketch_func = sketch.func
        sketch_title = sketch.title
        
        Hdiag, d_eff = Generate_H(alpha,reg=reg)
        
        for t in range(0,T):
            m = Find_Sketch_Dim(Hdiag, sketch_func, m0)
            if (m >= 1.5*d_eff and m <= np.max([4*d_eff,m0])):
                success_num = success_num + 1
                sketch_dim_avg = sketch_dim_avg + m/T
    
        print(alpha, d_eff, sketch_title, m0, success_num/T, sketch_dim_avg)
    



GaussianSketch= lambda: None
GaussianSketch.func = Gauss_Sketch
GaussianSketch.title = 'G'
np.random.seed(1234546)
Experiment(1,GaussianSketch,T=20)
np.random.seed(1234546)
Experiment(2/3,GaussianSketch,T=20)
np.random.seed(1234546)
Experiment(1/2,GaussianSketch,T=20)
    
RSketch= lambda: None
RSketch.func = R_Sketch
RSketch.title = 'R'
np.random.seed(1234546)
Experiment(1,RSketch,T=20)
np.random.seed(1234546)
Experiment(2/3,RSketch,T=20)
np.random.seed(1234546)
Experiment(1/2,RSketch,T=20)

SRSketch= lambda: None
SRSketch.func = SR_Sketch
SRSketch.title = 'SR'
np.random.seed(1234546)
Experiment(1,SRSketch,T=20)
np.random.seed(1234546)
Experiment(2/3,SRSketch,T=20)
np.random.seed(1234546)
Experiment(1/2,SRSketch,T=20)

        
    
    
    
    

